%% GMM estimation

clc
close all
clear all

path(pathdef)
addpath ./functions/

rng(1) % Set randomization seed

%% First, get xi from benchmark specification
load ../../'Estimation Results'/Benchmark_Model.mat

cd ./dynare_codes/ % Changing directory so dynare files and other mat files are saved there
Model_Moments(parameters, N_variables, N_ll); % This gives us xi
cd ../
%% Load Data Moments

load ../../'Data Moments'/target_data.mat

%% Calibrated parameters
beta    = 0.99;         % Discount factor
th_ss   = 0.0266892;	% Average extraction rate
MS_o    = 0.42270546;   % OPEC's market share
eta     = 6.11;         % Structural parameter - eta
lambda  = .07930421;    % Structural parameter - lambda
R_o     = 0.028643;     % Share of oil revenues out of world GDP
gamma   = 2;            % CRRA parameter
L       = 1/3;          % Steady state labor supply
alpha   = 1/3;          % Cobb-Douglas parameter on capital
delta   = 0.1;          % Depreciation rate on capital
nu      = 0.5;          % Labor supply elasticity

y       = [beta, th_ss, MS_o, lambda, eta, R_o, gamma, L, alpha, delta, nu, xi]; % Set of calibrated parameters

%% GMM estimation

cd ./dynare_codes/ % Changing directory so dynare files and other mat files are saved there


options = optimset('LargeScale', 'off',  'maxfunevals', 2000, 'PlotFcns',...
                {@optimplotx, @optimplotfval});

    
% Initial guess for estimated parameters
load ../../../'Estimation Results'/Benchmark_Model.mat GMM_est
x_0 = GMM_est;

W = diag(std_moments.^(-2)); % Weighting matrix for GMM procedure

[GMM_est, fval] = fminsearch(@(x) GMM_res_competitive(x, y, moments, W, N_variables ,N_ll), x_0, options);

x = GMM_est;

% Transforming x back to structural parameters:
x(1) = exp(x(1))/(1+exp(x(1)));                       % epsilon 
lambda(1:2) = (1 - 2 * exp(x(2:3))./(1+exp(x(2:3)))); % rhos eigenvalues
x(2) = lambda(1) + lambda(2);                         % rho_a1
x(3) = - lambda(1) * lambda(2);                       % rho_a2
lambda(1:2) = (1 - 2 * exp(x(4:5))./(1+exp(x(4:5)))); % rhos eigenvalues
x(4:5) = 10^(-7) + exp(x(4:5));                       % var_u var_a
x(4:5) = min(x(4:5), 5);

parameters = [y,x];
                         
%% Compute standard errors on estimated parameters


evalc('model_moments = Model_Moments_competitive(parameters, N_variables, N_ll);');

evalc('D = get_gradient_gmm_competitive(parameters, N_variables, N_ll);');


V = (D * W * D') \ (D * W * S0_delta * W' * D') / (D * W * D');
V = V / T;
std_error = diag(V).^(1/2);

cd ../
save ../../'Estimation Results'/competitive_model parameters psi GMM_est moments S0_delta D W std_moments T N_variables N_ll fval std_error model_moments